/*
 * Decompiled with CFR 0.152.
 */
package net.voidz.block;

import java.util.List;
import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.VoidShadowEntity;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.voidz.block.entity.PortalBlockEntity;
import net.voidz.dimension.VoidPlacementHandler;
import net.voidz.init.BlockInit;
import net.voidz.init.ConfigInit;
import net.voidz.init.DimensionInit;
import org.jetbrains.annotations.Nullable;

public class PortalBlock
extends Block
implements EntityBlock {
    public PortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PortalBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return PortalBlock.checkType(type, BlockInit.PORTAL_BLOCK_ENTITY, world.m_5776_() ? PortalBlockEntity::clientTick : PortalBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState stateBlock, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult blockHitResult) {
        if (!world.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)playerEntity.m_20193_();
            if (serverWorld.m_46472_() == DimensionInit.VOID_WORLD) {
                ServerLevel oldWorld;
                PortalBlockEntity portalBlockEntity;
                AABB box = new AABB(blockPos);
                List list = world.m_6443_(VoidShadowEntity.class, box.m_82400_(160.0), EntitySelector.f_20408_);
                if (!(playerEntity.m_7500_() || playerEntity.m_5833_() || list.isEmpty())) {
                    playerEntity.m_5661_((Component)Component.m_237113_((String)"Void Shadow: You can't escape the depths of this world as long as I am alive!"), false);
                    return InteractionResult.FAIL;
                }
                if (ConfigInit.CONFIG.allow_boss_respawn && list.isEmpty() && (portalBlockEntity = (PortalBlockEntity)world.m_7702_(blockPos)) != null && portalBlockEntity.bossTime != 0) {
                    int timer = ConfigInit.CONFIG.boss_respawn_time - ((int)world.m_6106_().m_6793_() - portalBlockEntity.bossTime);
                    playerEntity.m_5661_((Component)Component.m_237113_((String)("The Void Shadow will respawn in " + timer + " ticks")), false);
                }
                if ((oldWorld = serverWorld.m_7654_().m_129783_()) != null) {
                    if (playerEntity.m_20159_() && playerEntity.m_20202_() instanceof DragonEntity && playerEntity.m_6072_()) {
                        DragonEntity dragonEntity = (DragonEntity)playerEntity.m_20202_();
                        playerEntity.m_8127_();
                        FabricDimensions.teleport((Entity)dragonEntity, (ServerLevel)oldWorld, (PortalInfo)VoidPlacementHandler.leave((ServerPlayer)playerEntity, oldWorld, blockPos));
                        return InteractionResult.SUCCESS;
                    }
                    FabricDimensions.teleport((Entity)playerEntity, (ServerLevel)oldWorld, (PortalInfo)VoidPlacementHandler.leave((ServerPlayer)playerEntity, oldWorld, blockPos));
                    return InteractionResult.FAIL;
                }
            } else {
                ServerLevel voidWorld = serverWorld.m_7654_().m_129880_(DimensionInit.VOID_WORLD);
                if (voidWorld == null) {
                    playerEntity.m_5661_((Component)Component.m_237113_((String)"Failed to find void world, was it registered?"), false);
                    return InteractionResult.FAIL;
                }
                FabricDimensions.teleport((Entity)playerEntity, (ServerLevel)voidWorld, (PortalInfo)VoidPlacementHandler.enter((ServerPlayer)playerEntity, voidWorld, blockPos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

